//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Collections;
using System.Threading;

namespace DelegatesAndEvents
{
	public enum ChangeType {Add, Subtract}

	public class ChangedClass 
	{
		// Zdarzenie, ktre moe by uyte do powiadomienia klientw o zmianie
		// elementw listy:
		public delegate void ChangeHandler(ChangeType type, int count);
		public event ChangeHandler Changed;
		private int count;
		public ChangedClass()
		{
			count = 0;
		}
		// Wywoanie zdarzenia Changed przy kadej zmianie listy:
		protected void OnChanged(ChangeType type, int count) 
		{
			if (Changed != null)
			{
				Changed(type, count);
			}
		}
		public void Add()
		{
			Interlocked.Increment(ref count);
			OnChanged(ChangeType.Add, count);
		}
		public void Subtract()
		{
			Interlocked.Decrement(ref count);
			OnChanged(ChangeType.Subtract, count);
		}
	}

	class Test 
	{
		private static void Changed(ChangeType type, int count) 
		{
			Console.WriteLine("Wywoano Changed {0} {1}", count, type);
		}
		private static void Modified(ChangeType type, int count) 
		{
			Console.WriteLine("Wywoano Modified {0} {1}", count, type);
		}
		public static void Main() 
		{
			// Utworzenie nowej listy:
			ChangedClass changed = new ChangedClass();
			changed.Changed += new ChangedClass.ChangeHandler(Changed);
			changed.Changed += new ChangedClass.ChangeHandler(Modified);
			changed.Add();
			changed.Add();
			changed.Changed -= new ChangedClass.ChangeHandler(Modified);
			changed.Add();
			changed.Add();
			changed.Subtract();
			changed.Subtract();
			changed.Subtract();
			// Delegate [] da = changed.Changed.GetInvocationList();
		}
	}
}
